<?php

namespace frontend\modules\retails\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\modules\retails\models\Retails;

/**
 * RetailsSearch represents the model behind the search form of `frontend\models\Retails`.
 */
class RetailsSearch extends Retails
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'cid', 'receivable', 'income_head', 'dbank', 'shop_id'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Retails::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'cid' => Yii::$app->user->identity->cid,
            'receivable' => $this->receivable,
            'income_head' => $this->income_head,
            'dbank' => $this->dbank,
            'shop_id' => $this->shop_id,
        ]);

        return $dataProvider;
    }
}
