<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "sales".
 *
 * @property string $id
 * @property int $cid
 * @property int $item_id
 * @property string $item_name
 * @property double $qty
 * @property double $supply_price
 * @property double $unit_price
 * @property double $total
 * @property string $transaction_id
 * @property string $payment_type
 * @property int $customer_id
 * @property int $staff
 * @property double $tax
 * @property double $discount
 * @property double $tendered
 * @property double $balance
 * @property string $created_at
 * @property string $updated_at
 * @property int $supplier
 */
class Sales extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'sales';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cid', 'item_id', 'item_name', 'qty', 'unit_price', 'total', 'transaction_id', 'payment_type', 'staff'], 'required'],
            [['cid', 'item_id', 'customer_id', 'staff', 'supplier'], 'integer'],
            [['qty', 'supply_price', 'unit_price', 'total', 'tax', 'discount', 'tendered', 'balance'], 'number'],
            [['created_at', 'updated_at'], 'safe'],
            [['item_name'], 'string', 'max' => 250],
            [['transaction_id'], 'string', 'max' => 200],
            [['payment_type'], 'string', 'max' => 17],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'item_id' => 'Item ID',
            'item_name' => 'Item Name',
            'qty' => 'Qty',
            'supply_price' => 'Supply Price',
            'unit_price' => 'Unit Price',
            'total' => 'Total',
            'transaction_id' => 'Transaction ID',
            'payment_type' => 'Payment Type',
            'customer_id' => 'Customer ID',
            'staff' => 'Staff',
            'tax' => 'Tax',
            'discount' => 'Discount',
            'tendered' => 'Tendered',
            'balance' => 'Balance',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'supplier' => 'Supplier',
        ];
    }
}
