<?php

namespace frontend\modules\retails\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\modules\retails\models\Shelves;

/**
 * ShelvesSearch represents the model behind the search form of `frontend\models\Shelves`.
 */
class ShelvesSearch extends Shelves
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'cid'], 'integer'],
            [['shelf_name', 'created_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Shelves::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'cid' => Yii::$app->user->identity->cid,
            'created_at' => $this->created_at,
        ]);

        $query->andFilterWhere(['like', 'shelf_name', $this->shelf_name]);

        return $dataProvider;
    }
}
