<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "shifts".
 *
 * @property int $id
 * @property string $shift_id
 * @property int $shop_id
 * @property int $cid
 * @property int $staff_id
 * @property string $shift_name
 * @property int $status
 * @property string $stamp
 * @property string $created_at
 */
class Shifts extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'shifts';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['shift_id', 'shop_id', 'cid', 'staff_id', 'shift_name', 'stamp'], 'required'],
            [['shop_id', 'cid', 'staff_id', 'status'], 'integer'],
            [['created_at'], 'safe'],
            [['shift_id', 'shift_name', 'stamp'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'shift_id' => 'Shift ID',
            'shop_id' => 'Shop ID',
            'cid' => 'Cid',
            'staff_id' => 'Staff ID',
            'shift_name' => 'Shift Name',
            'status' => 'Status',
            'stamp' => 'Stamp',
            'created_at' => 'Created At',
        ];
    }
}
