<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "stock".
 *
 * @property int $id
 * @property double $quantity adjustment quantity
 * @property int $direction are you increasing or decreasing
 * @property int $status approved or rejected
 * @property int $manager 1 is for shop ans 2 is for store. is it for store manager to approve or shop manager
 * @property double $item_id
 * @property int $staff
 * @property string $created_at
 * @property int $cid
 */
class Stock extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'stock';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['quantity', 'direction', 'manager', 'item_id', 'staff', 'created_at', 'cid'], 'required'],
            [['quantity', 'item_id'], 'number'],
            [['direction', 'status', 'manager', 'staff', 'cid'], 'integer'],
            [['created_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'quantity' => 'Quantity',
            'direction' => 'Direction',
            'status' => 'Status',
            'manager' => 'Manager',
            'item_id' => 'Item ID',
            'staff' => 'Staff',
            'created_at' => 'Created At',
            'cid' => 'Cid',
        ];
    }
}
