<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "stores".
 *
 * @property int $id
 * @property int $cid
 * @property string $name
 * @property double $quantity
 * @property string $particulars
 * @property string $received_date
 * @property string $issued_date
 * @property int $recieved_by
 * @property int $issued_by
 * @property int $given_to
 * @property string $description
 * @property string $transaction_id
 * @property double $balance
 * @property string $units
 * @property int $countable
 * @property double $cost_price
 */
class Stores extends \yii\db\ActiveRecord implements \yz\shoppingcart\CartPositionInterface
{
  
    public $price;
    

    /**
     * @inheritdoc
     */
  

    use  \yz\shoppingcart\CartPositionTrait;
    public function getPrice()
    {
        return $this->price;
    }

    public function getId()
    {
        return $this->id;
    }
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'stores';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'name', 'particulars', 'quantity', 'units', 'countable'], 'required'],
            [['cid', 'recieved_by', 'issued_by', 'given_to', 'countable'], 'integer'],
            [['name', 'particulars', 'description'], 'string'],
            [['quantity', 'balance', 'cost_price'], 'number'],
            [['received_date', 'issued_date'], 'safe'],
            [['transaction_id'], 'string', 'max' => 200],
            [['units'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'name' => 'Name',
            'quantity' => 'Quantity',
            'particulars' => 'Particulars',
            'received_date' => 'Received Date',
            'issued_date' => 'Issued Date',
            'recieved_by' => 'Recieved By',
            'issued_by' => 'Issued By',
            'given_to' => 'Given To',
            'description' => 'Description',
            'transaction_id' => 'Transaction ID',
            'balance' => 'Balance',
            'units' => 'Units',
            'countable' => 'Countable',
            'cost_price' => 'Cost Price',
        ];
    }
}
