<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "tabs".
 *
 * @property int $id
 * @property string $customer
 * @property string $bill_ids
 * @property int $cid
 * @property int $status
 * @property int $shop_type
 */
class Tabs extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tabs';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer', 'bill_ids', 'cid', 'status', 'shop_type'], 'required'],
            [['bill_ids'], 'string'],
            [['cid', 'status', 'shop_type'], 'integer'],
            [['customer'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'customer' => 'Customer',
            'bill_ids' => 'Bill Ids',
            'cid' => 'Cid',
            'status' => 'Status',
            'shop_type' => 'Shop Type',
        ];
    }
}
