<?php

namespace frontend\modules\retails\models;

use Yii;

/**
 * This is the model class for table "taken".
 *
 * @property int $id
 * @property string $address
 * @property string $phone
 * @property string $email
 * @property int $room_no
 * @property int $room_type
 * @property int $guest_id
 * @property string $departure
 * @property string $nok
 * @property int $status
 * @property double $deposit
 * @property int $payment_method
 * @property string $id_type
 * @property string $id_no
 * @property int $cid
 * @property string $transaction_id
 * @property string $created_at
 * @property string $updated_at
 * @property int $bill_to
 * @property int $company
 * @property int $complimentary
 * @property string $reservation_no
 * @property double $rate
 * @property double $discount
 */
class Taken extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $utila;
    public static function tableName()
    {
        return 'taken';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['address', 'phone', 'room_no', 'room_type', 'guest_id', 'departure', 'deposit', 'payment_method', 'cid', 'transaction_id', 'created_at', 'bill_to', 'rate'], 'required'],
            [['address'], 'string'],
            [['room_no', 'room_type', 'guest_id', 'status', 'payment_method', 'cid', 'bill_to', 'company', 'complimentary'], 'integer'],
            [['departure', 'created_at', 'updated_at'], 'safe'],
            [['deposit', 'rate', 'discount'], 'number'],
            [['phone'], 'string', 'max' => 17],
            [['email'], 'string', 'max' => 40],
            [['nok', 'id_type', 'id_no', 'transaction_id'], 'string', 'max' => 225],
            [['reservation_no'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'address' => 'Address',
            'phone' => 'Phone',
            'email' => 'Email',
            'room_no' => 'Room No',
            'room_type' => 'Room Type',
            'guest_id' => 'Guest ID',
            'departure' => 'Departure',
            'nok' => 'Nok',
            'status' => 'Status',
            'deposit' => 'Deposit',
            'payment_method' => 'Payment Method',
            'id_type' => 'Id Type',
            'id_no' => 'Id No',
            'cid' => 'Cid',
            'transaction_id' => 'Transaction ID',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'bill_to' => 'Bill To',
            'company' => 'Company',
            'complimentary' => 'Complimentary',
            'reservation_no' => 'Reservation No',
            'rate' => 'Rate',
            'discount' => 'Discount',
        ];
    }
}
