<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel frontend\models\AccountsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Accounts';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="accounts-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Accounts', ['create'], ['class' => 'btn btn-success']) ?>
        <?= Html::a('Fund Accounts', ['accounts/fund'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'company',
            'tel',
            'address:ntext',
            'contact_person',
            ['label'=>'Action', 'format'=>'raw', 'attribute'=>'move_out_date', 'value'=>function ($model){  return Html::a('Generate Bill: '.ucwords($model->company),['/accounts/generate','id'=>$model->id],['class'=>'btn btn-primary', 'style'=>'display:block;']); }],
            // ['label'=>'Action', 'format'=>'raw', 'attribute'=>'move_out_date', 'value'=>function ($model){  return Html::a('Fund Account: '.ucwords($model->company),['/accounts/fund','id'=>$model->id],['class'=>'btn btn-primary', 'style'=>'display:block;']); }],
            //'email:email',
            //'cid',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
