<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

use yii\helpers\ArrayHelper;

use frontend\models\Agroups;

/* @var $this yii\web\View */
/* @var $model frontend\models\Charts */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="charts-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'anumber')->textInput()->label('Account Code') ?>

    <?= $form->field($model, 'title')->textInput() ?>

    <?php echo $form->field($model, 'to_increase')->dropDownList(
    ['1'=>'Debit','2'=>'Credit'],['prompt'=>'']) ?>

    <?= $form->field($model, 'description')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <?php echo $form->field($model, 'atype')->dropDownList(
    ['1'=>'Asset','2'=>'Liability','3'=>'Equity','4'=>'Revenue','5'=>'Expenses'],['prompt'=>''])->label('Account Type') ?>

    
<?php echo $form->field($model, 'account_group')->dropDownList(
    ArrayHelper::map(Agroups::find()->all(),'id','name'),['prompt'=>'']) ?>
    
    <?php echo $form->field($model, 'pnl')->dropDownList(
    ['1'=>'Yes','2'=>'No'],['prompt'=>''])->label('Proffit and loss item?') ?>

      <?= $form->field($model, 'created_at')->hiddenInput(['value'=>date('Y-m-d')])->label(false) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
