<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

use yii\helpers\ArrayHelper;

use frontend\models\Charts;
use frontend\models\Stores;
use frontend\models\Inventory;
?>
<div>
<h1>Adjustment Report</h1>

<div style="display:block; width:100%; overflow:auto; height:auto; margin-bottom:50px;">
 <?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['inventory/ad_report'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'date1',
    'id' => 'date1',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'date2',
    'id' => 'date2',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,

    ]
]); ?>

</div>
        
        
        
        <div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>
<?php if($result!=null){ ?>

<h4>Report for period between <?= date('jS F Y',strtotime($date1)) ?> and <?= date('jS F Y',strtotime($date2)) ?></h4>
<table class="table table-striped table-bordered">
<tr>
<td>NAME</td>
<TD>SOURCE</TD>
<TD>QUANTITY</TD>
<td>DIRECTION</td>
</tr>

<?php
foreach($result as $res)
{   if($res['source']==2){ $name=Stores::findOne($res['item_id'])->name; }
	if($res['source']==1){ $name=Inventory::findOne($res['item_id'])->name; }
	?>
	<tr>
<td><?= $name ?></td>
<td><?= $res['source']==2 ? 'STORE' : 'SHOP' ?></td>
<td><?= $res['quantity'] ?></td>
<td><?= $res['direction']==2 ? 'DECREASE' : 'INCREASE' ?></td>
</tr>

	<?php
}
}
?>
</table>

</div>