<?php
use kartik\date\DatePicker;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

?>
<h2>Journal Entries</h2>

<div style="display:block; width:100%; overflow:auto; height:auto; margin-bottom:50px;">
 <?php $form = ActiveForm::begin(['action' => Yii::$app->UrlManager->createUrl(['ledger/journal']), 'method' => 'post']);?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
	'name' => 'date1',
	'id' => 'date1',
	'options' => ['autocomplete' => 'Off'],
	//'value' => date('Y-m-d'),
	'pluginOptions' => [
		'autoclose' => true,
		'format' => 'yyyy-mm-dd',
		'todayHighlight' => true,

	],
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
	'name' => 'date2',
	'id' => 'date2',
	'options' => ['autocomplete' => 'Off'],
	// 'value' => date('Y-m-d'),
	'pluginOptions' => [
		'autoclose' => true,
		'format' => 'yyyy-mm-dd',
		'todayHighlight' => true,

	],
]); ?>

</div>


        <div class="form-group">
        <?=Html::submitButton('Fetch', ['class' => 'btn btn-success'])?>
    </div>

    <?php ActiveForm::end();?>
</div>



<div id="holder">
	<h2>MORRIS ROYAL SECURITY</h2>
	<h3>JOURNAL ENTRIES</h3>
	<?php
if ($entries != null) {
	?>
			<h3>
			<?=date('jS F Y', strtotime($date1)) . ' to ' . date('jS F Y', strtotime($date2))?>
		</h3>

			<?php
}
?>
	<table class="table table-striped table-bordered">

		<tr>
			<th>DATE</th>
			<th>ACCOUNT</th>
			<th>DEBIT</th>
			<th>CREDIT</th>
			<th></th>
			<th></th>
		</tr>
		<?php
if ($entries != null) {
	$tid = null;
	foreach ($entries as $entry) {

		?>
			<?php if ($tid != $entry['transaction_id']) {?>
			<tr>
			<th colspan="6">JOURNAL ENTRY NO: <?=$entry['transaction_id']?></th>
		</tr>
		<tr>
			<th colspan="4" style="text-transform: uppercase; text-align: right;"><?php // echo ucfirst($entry['details'])  ?></th>
		</tr>
	<?php }?>
		<tr>
			<td><?=date('jS F Y', strtotime($entry['created_at']))?></td>
			<td>
				<?=$entry['entry_type'] && !empty($entry->accounts->title) == 1 ? $entry->accounts->title : '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-style:italic;">' . ucfirst($entry->accounts->title) . '</span>';?>
			</td>

			<td>
				<?=$entry['entry_type'] == 1 ? number_format(abs($entry['amount']), 2) : ''?>
			</td>
			<td>
				<?=$entry['entry_type'] == 2 ? number_format(abs($entry['amount']), 2) : ''?>
			</td>
			<th>

				<?php // echo Html::a('Reverse', ['reverse', 'tid' => $entry['transaction_id']], ['class' => 'btn btn-primary narrow','id'=>'noshow','data'=>['confirm'=>'You are about to delete a journal Entry!']]) ?>
			</th>

			<th>

				<?php // echo  Html::a('Edit', ['update', 'id' => $entry['id']], ['class' => 'btn btn-primary narrow','id'=>'noshow','target'=>'_blank']) ?>
			</th>
		</tr>

			<?php
$tid = $entry['transaction_id'];
	}
}
?>
	</table>

</div>

<div>
    <?=Html::button('Print', ['class' => 'btn btn-success', 'onclick' => 'print()'])?>
</div>




