<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

?>

<h1>Print Receipts</h1>


<div style="display:block; width:100%; overflow:auto; height:auto; margin-bottom:50px;">
 <?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['ledger/receipts'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'date1',
    'id' => 'date1',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'date2',
    'id' => 'date2',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,

    ]
]); ?>

</div>
<div class="form-group well well-sm">
	<?= Html::textInput('guest',null,['class'=>'form-control','onkeyup'=>'fillup4()','id'=>'util','placeholder'=>'Enter Guest Name']) ?>
</div>
<div id="fida"></div>
<div>
	<?= Html::hiddenInput('guest','',['class'=>'form-control','id'=>'guest']) ?>
</div>        
        
        
        <div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>

<div>
	<?php
		if($items!=null){
			?>
				<table class="table table-bordered table-striped">
					<tr>
						<th>GUEST</th>
					<th>RECEIPT ID</th>
					<th>AMOUNT PAID</th>
					<th>RECEIPT</th>
					</tr>

					<?php
						foreach($items as $item)
						{
							?>

								<tr>
									<td><?= 										
										is_numeric($item['vendor']) ? ucwords(\frontend\models\Customers::findOne($item['vendor'])->name) : ucwords($item['vendor']).' -  Reservation'; ?>
									</td>
									<td><?= $item['transaction_id'] ?></td>
									<td><?= $item['amount_paid'] ?></td>
									<td><?= Html::button('View',['class'=>'btn btn-primary','onclick'=>'pull_receipt('.$item["id"].')']) ?></td>
								</tr>

							<?php
						}
					?>
				</table>
			<?php
		}
	?>
</div>

<div id="holder" style="display:block; margin: auto;">
	
</div>

<div style="margin-top: 20px; margin-bottom: 20px;">
	<?= Html::button('Print',['class'=>'btn btn-primary','onclick'=>'print()']) ?>
</div>