<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\models\Banks;
use yii\helpers\ArrayHelper;
use frontend\models\Customers;
use frontend\models\Vendors;
?>
<h1>Sales Receipts</h1>
<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['ledger/sales'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,

    ]
]); ?>

</div>

<div class="well well-sm">
 <?= Html::textInput('tid',null,['class'=>'form-control','placeholder'=>'Enter Transaction ID','id'=>'tid','autocomplete'=>'off']) ?>
</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>

<div>
<table class="table table-bordered table-striped">
<tr>
	<th>Date</th>
	<th>Vendor</th>
<th>Transaction ID</th>
<th>Amount Paid (<del>N</del>)</th>
<th>Type</th>
<th>Parent Transaction</th>
<th></th>
</tr>

<?php
foreach($sales as $sale)
{
	?>
<tr>
	<td><?= date('jS F Y',strtotime($sale->created_at)) ?></td>
	<td><?= ucwords(Customers::findOne($sale->vendor)->name) ?></td>
<td><?= $sale->transaction_id ?></td>
<td><?= number_format($sale->amount_paid,2) ?></td>
<td><?= $sale->ptype==1 ? 'Expenditure' : 'Sale' ?></td>
<td><?= $sale->tlink ?></td>
<td>
<?= Html::button('Show Receipt',['onclick'=>'show_receipt('.$sale['transaction_id'].','.$sale['tlink'].')','class'=>'btn btn-primary']) ?>

</td>


</tr>

	<?php
}
?>
</table>
</div>



<div id="receipt" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body" id="holder">
      	
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>
