<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\models\Payment;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model frontend\models\Reservations */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="reservations-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'contact_person')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'phone')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'number_of_rooms')->textInput() ?>

    
    <div class="well well-sm">
<?php
echo '<label class="control-label">Reservation Date</label>';
echo DatePicker::widget([
    'model'=>$model,
    'attribute' => 'reservation_date',
    'id' => 'reservation_date',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
    ]
]); ?>

</div>

    <?= $form->field($model, 'amount_paid')->textInput() ?>

    <?= $form->field($model, 'discount')->textInput() ?>

    <?= $form->field($model, 'created_at')->hiddenInput(['value'=>date('Y-m-d')])->label(false) ?>

    <?= $form->field($model, 'staff')->hiddenInput(['value'=>Yii::$app->user->identity->id])->label(false) ?>

    <?php echo $form->field($model, 'payment')->dropDownList(
    ArrayHelper::map(Payment::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','name'),['prompt'=>'']) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
