<?php

use yii\helpers\Html;
use yii\grid\GridView;
use frontend\models\Charts;

/* @var $this yii\web\View */
/* @var $searchModel frontend\models\RetailsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Retails';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="retails-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Retails', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
           // 'cid',
           // 'receivable',
             ['label'=>'Receivable', 'format'=>'raw', 'attribute'=>'cid', 'value'=>function ($model){  return ucwords(Charts::findOne($model->receivable)->title); }], 
            //'income_head',
             ['label'=>'Income Head', 'format'=>'raw', 'attribute'=>'cid', 'value'=>function ($model){  return ucwords(Charts::findOne($model->income_head)->title); }], 
            //'dbank',
             ['label'=>'Bank', 'format'=>'raw', 'attribute'=>'cid', 'value'=>function ($model){  return ucwords(Charts::findOne($model->dbank)->title); }], 
            'shop_id',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
