<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use frontend\models\Charts;
use yii\helpers\ArrayHelper;


/* @var $this yii\web\View */
/* @var $model frontend\models\AutoLegs */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="auto-legs-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>    

    <?php echo $form->field($model, 'debit')->dropDownList(
    ArrayHelper::map(Charts::find()->OrderBy('title asc')->all(),'id','title'),['prompt'=>'']) ?>

<?php echo $form->field($model, 'credit')->dropDownList(
    ArrayHelper::map(Charts::find()->OrderBy('title asc')->all(),'id','title'),['prompt'=>'']) ?>

<?php echo $form->field($model, 'leg_type')->dropDownList(
    ArrayHelper::map(\frontend\models\LegTypes::find()->all(),'id','name'),['prompt'=>'']) ?>

<?= $form->field($model, 'cid')->hiddenInput(['maxlength' => true, 'value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
