<?php

use yii\helpers\Html;
use yii\grid\GridView;
use backend\models\Clients;

/* @var $this yii\web\View */
/* @var $searchModel frontend\models\SearchCategories */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Categories';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="categories-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Categories', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            // 'cid',
             ['label'=>'Client', 'format'=>'raw', 'attribute'=>'cid', 'value'=>function ($model){  return ucwords(Clients::findOne($model->cid)->client_name); }], 
            'category_name',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
