<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use frontend\models\Banks;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model frontend\models\Config */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="config-form">

    <?php $form = ActiveForm::begin(); ?>

     <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

      <?= Html::activeDropDownList($model,'bank', ArrayHelper::map(Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'bid','bank'),['class'=>'form-control','prompt'=>'Select Bank','id'=>'shop']) ?>

    <?= $form->field($model, 'company')->textInput(['maxlength' => true]) ?>

    <?= Html::activeDropDownList($model,'to_staff', [''=>'',1=>'Make Staff Customer for Retail Sales (Bars/Restaurants)'],['class'=>'form-control','id'=>'shop']) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
