<?php
use backend\models\Clients;
use kartik\sidenav\SideNav;
use yii\helpers\Html;
use yii\helpers\Url;
?>
<?php $this->beginContent('@app/views/layouts/main.php');?>
<?php
$client_type = Clients::findOne(Yii::$app->user->identity->cid)->industry;
?>
        <div class="container">

            <div class="col-sm-3">
               <?=
SideNav::widget([
	'type' => $type,
	'encodeLabels' => false,
	'heading' => $heading,
	'items' => [
		// Important: you need to specify url as 'controller/action',
		// not just as 'controller' even if default action is used.
		//
		// NOTE: The variable `$item` is specific to this demo page that determines
		// which menu item will be activated. You need to accordingly define and pass
		// such variables to your view object to handle such logic in your application
		// (to determine the active status).
		//
		['label' => 'Dashboard', 'icon' => 'home', 'url' => Url::to(['/site/dashboard', 'type' => $type]), 'active' => ($item == 'home')],
		// ['label' => 'Tasks', 'icon' => 'book', 'items' => [
		//     ['label' => '<span class="pull-right badge"></span> Inflow', 'url' => Url::to(['/sales/store', 'type'=>$type]), 'active' => ($item == 'store')],
		//     ['label' => '<span class="pull-right badge"></span> Outflow', 'url' => Url::to(['/requisitions/create', 'type'=>$type]), 'active' => ($item == 'create')],

		// ]],

		['label' => '<span class="pull-right badge" id="note_sum"></span> Notifications', 'icon' => 'bullhorn', 'items' => [
			['label' => 'Attention Required <span class="badge" id="atten"></span>', 'url' => Url::to(['/requisitions/attentionrequired', 'type' => $type]), 'active' => ($item == 'attentionrequired')],
			['label' => 'Rejections <span class="badge" id="rej"></span>', 'url' => Url::to(['/requisitions/allrejections', 'type' => $type]), 'active' => ($item == 'allrejections')],
			['label' => 'Action Notifications <span class="badge" id="note_count"></span>', 'url' => Url::to(['/requisitions/allnotifications', 'type' => $type]), 'active' => ($item == 'allnotifications')],
			['label' => 'Messages <span class="badge" id="mess4"></span>', 'url' => Url::to(['/site/sendm2', 'type' => $type]), 'active' => ($item == 'allnotifications')],
		]],
		['label' => 'Reports', 'icon' => 'book', 'items' => [
			['label' => '<span class="pull-right badge"></span> Transactions Report', 'url' => Url::to(['/reports/rinflow', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' ? true : false],
			['label' => '<span class="pull-right badge"></span> All Transactions', 'url' => Url::to(['/requisitions/allrequisitions', 'type' => $type]), 'active' => ($item == 'most-popular'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' ? true : false,
			],
			['label' => '<span class="pull-right badge"></span> My Transactions', 'url' => Url::to(['/requisitions/myrequisitions', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Sales Report', 'url' => Url::to(['/sales/sales_report', 'type' => $type]), 'active' => ($item == 'most-popular'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'Shop Manager' ? true : false],
			['label' => '<span class="pull-right badge"></span> Adjustment Report', 'url' => Url::to(['/inventory/ad_report', 'type' => $type]), 'active' => ($item == 'most-popular'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'Shop Manager' ? true : false],
			['label' => '<span class="pull-right badge"></span> Sales list', 'url' => Url::to(['/ledger/sales_list', 'type' => $type]), 'active' => ($item == 'most-popular'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'Shop Manager' ? true : false],
			['label' => '<span class="pull-right badge"></span> Stock Value Report', 'url' => Url::to(['/inventory/trading', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' ? true : false],
			//&& $client_type==1

		],
			'visible' => Yii::$app->user->identity->role == 'Client Admin' || $client_type == 1 ? true : false],

		['label' => 'Accounts', 'icon' => 'book', 'items' => [
			['label' => '<span class="pull-right badge"></span> Chart of Accounts', 'url' => Url::to(['/charts/index', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Profit & Loss', 'url' => Url::to(['/requisitions/pnl', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			//  ['label' => '<span class="pull-right badge"></span> Payments & Receipts', 'url' => Url::to(['/requisitions/pnld', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Main Ledger', 'url' => Url::to(['/ledger/cashbookk', 'type' => $type]), 'active' => ($item == 'most-popular'), //,'visible'=>Yii::$app->user->identity->role=='Client Admin'  ? true : false
			],
			['label' => '<span class="pull-right badge"></span> Customer Balances', 'url' => Url::to(['/ledger/debtors', 'type' => $type]), 'active' => ($item == 'most-popular')],
			// ['label' => '<span class="pull-right badge"></span> CashBook 2', 'url' => Url::to(['/ledger/cash', 'type'=>$type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Sales Report', 'url' => Url::to(['/sales/sales_report', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Vendor Balances', 'url' => Url::to(['/ledger/creditors', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Reverse Transaction', 'url' => Url::to(['/ledger/reverse', 'type' => $type]), 'active' => ($item == 'most-popular')],
			// ['label' => '<span class="pull-right badge"></span> Reverse Transaction', 'url' => Url::to(['/ledger/reverse', 'type' => $type]), 'active' => ($item == 'most-popular'), 'visible' => $client_type == 1 ? true : false],
			['label' => '<span class="pull-right badge"></span> Sales Receipts ', 'url' => Url::to(['/ledger/sales', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Trial Balance ', 'url' => Url::to(['/ledger/trial', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Balance Sheet ', 'url' => Url::to(['/ledger/balance', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Entry Details ', 'url' => Url::to(['/ledger/accounts', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Post Entry ', 'url' => Url::to(['/ledger/entry', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Transfer Cash ', 'url' => Url::to(['/ledger/cash_transfer', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Journal Entry ', 'url' => Url::to(['/ledger/journal', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Print Chart of Accounts ', 'url' => Url::to(['/ledger/print_chart', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Edit Journal Entries ', 'url' => Url::to(['/ledger/journalnew', 'type' => $type]), 'active' => ($item == 'most-popular')],

		], 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'accounts' ? true : false],

		['label' => 'Store', 'icon' => 'book', 'items' => [
			['label' => '<span class="pull-right badge"></span> Store Ledger', 'url' => Url::to(['/stores/sledger', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Vendors', 'url' => Url::to(['/vendors/index', 'type' => $type]), 'active' => ($item == 'most-popular')],
			['label' => '<span class="pull-right badge"></span> Vendor Ledger', 'url' => Url::to(['/vendors/vledger', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Stock Movement', 'url' => Url::to(['/stores/movement', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Store Adjustment Requests', 'url' => Url::to(['/inventory/arequest1', 'type' => $type]), 'active' => ($item == 'new-arrivals')],

		], 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'Store Manager' ? true : false],

		['label' => 'Shop', 'icon' => 'book', 'items' => [
			['label' => '<span class="pull-right badge"></span> Shop Ledger', 'url' => Url::to(['/inventory/dledger', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Customer Details', 'url' => Url::to(['/customers/index', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Customer Ledger', 'url' => Url::to(['/customers/cledger', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Stock Movement', 'url' => Url::to(['/inventory/movement', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Shop Adjustment Request', 'url' => Url::to(['/inventory/arequest2', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Open Shift', 'url' => Url::to(['/shifts/create', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Active Shifts', 'url' => Url::to(['/shifts/shifts', 'type' => $type]), 'active' => ($item == 'new-arrivals')],
			['label' => '<span class="pull-right badge"></span> Sales Report', 'url' => Url::to(['/sales/sales_report', 'type' => $type]), 'active' => ($item == 'most-popular'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'Shop Manager' ? true : false],

		], 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'Shop Manager' ? true : false],

		['label' => 'Register', 'icon' => 'book', 'items' => [
			['label' => '<span class="pull-right badge"></span> My Ledger', 'url' => Url::to(['/transaction/mledger', 'type' => $type]), 'active' => ($item == 'new-arrivals')],

			['label' => '<span class="pull-right badge"></span> Other Users Ledger', 'url' => Url::to(['/transaction/uledger', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' ? true : false],

		]],

		['label' => 'Production', 'icon' => 'book', 'items' => [

			['label' => '<span class="pull-right badge"></span> Production Manager Ledger', 'url' => Url::to(['/transaction/mmledger', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' ? true : false],

			['label' => '<span class="pull-right badge"></span>Production Ledger', 'url' => Url::to(['/transaction/pledger', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'Production Manager' ? true : false],
			['label' => '<span class="pull-right badge"></span>Batch Ledger', 'url' => Url::to(['/transaction/bledger', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'Production Manager' ? true : false],
			['label' => '<span class="pull-right badge"></span>Convertion Tables', 'url' => Url::to(['/boq/list', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'Production Manager' ? true : false],
		]],

		['label' => 'Human Resources', 'icon' => 'book', 'items' => [

			['label' => '<span class="pull-right badge"></span>Approved Staff List', 'url' => Url::to(['/hr/personaldetails/approved', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'Client Admin' || Yii::$app->user->identity->role == 'accounts' || (Yii::$app->user->identity->role == 'HR' && Yii::$app->user->identity->place == 1) ? true : false],
			['label' => '<span class="pull-right badge"></span>All Staff List', 'url' => Url::to(['/hr/personaldetails/allstaff', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'HR' && Yii::$app->user->identity->place == 1 ? true : false],
			['label' => '<span class="pull-right badge"></span>Staff Archive', 'url' => Url::to(['/hr/personaldetails/varchive', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'HR' && Yii::$app->user->identity->place == 1 ? true : false],
			['label' => '<span class="pull-right badge"></span>Clock Staff Attendance', 'url' => Url::to(['/hr/personaldetails/apage', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => (Yii::$app->user->identity->role == 'HR' && Yii::$app->user->identity->place == 2) ? true : false],
			['label' => '<span class="pull-right badge"></span>View Attendance', 'url' => Url::to(['/hr/personaldetails/viewattendance', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'HR' ? true : false],
			['label' => '<span class="pull-right badge"></span>View Staff by Deployment', 'url' => Url::to(['/hr/personaldetails/locate', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'HR' ? true : false],
			['label' => '<span class="pull-right badge"></span>View Staff at Location', 'url' => Url::to(['/hr/personaldetails/locate2', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => Yii::$app->user->identity->role == 'HR' ? true : false],
			['label' => '<span class="pull-right badge"></span>Payroll', 'url' => Url::to(['/hr/personaldetails/payroll', 'type' => $type]), 'active' => ($item == 'new-arrivals'), 'visible' => (Yii::$app->user->identity->role == 'HR' && Yii::$app->user->identity->place == 1) ? true : false],
		]],

		
	],
]);
?>
        <div id="loader" style="display:none;"><?php echo Html::img('@web/loaders/loader11.gif', ['class' => 'pull-center img-responsive']); ?></div>
            </div>

            <div id="content" class="col-sm-9">
                    <?php echo $content; ?>
            </div><!-- content -->



        </div>
<?php $this->endContent();