<?php
use yii\helpers\Html;
use frontend\models\Rooms;
use yii\helpers\ArrayHelper;
use frontend\models\Inventory;
use kartik\date\DatePicker;
use yii\widgets\ActiveForm;
use frontend\models\Payment;
use frontend\models\IdType;
use frontend\models\Taken;

use frontend\models\Shifts;

 $shift=Shifts::find()->where(['shift_name'=>Yii::$app->user->identity->id,'status'=>1])->one();
        if($shift==null){
          die('You do not have an open shift to sell. Please click the back button');
        }



?>

<div>
<h1>Rooms</h1>
<div style="border:1px solid #ccc; display:block;height:auto; overflow:auto; margin:auto; margin-bottom:20px;">

<span style="float:left; padding:10px; color:#fff; text-align:center; background-color:#66F;">Booked</span>
<span style="float:left; padding:10px; color:#fff; text-align:center; background-color:#F96;">Vaccant</span>
<span style="float:left; padding:10px; color:#000; text-align:center; background-color:yellow;">Out of Service</span>
<span style="float:left; padding:10px; color:#fff; text-align:center; background-color:red;">Complimentary</span>
</div>
<table class="table table-striped ">
	<tr>
<?php

foreach($rooms as $room)
{
	$comp=Taken::find()->where(['room_no'=>$room->room_number,'room_type'=>$room->type,'status'=>1])->one();


  $color="#F96";
	$color2="#000000";

	if($room->booked==1)
	{
		$color="#66F";
		$color2="#ffffff";
	}


    if($comp->complimentary==1)
    {
        $color="red";
        $color2="#ffffff";
    }
	?>


<td style="width:120px; height:120px; display:inline-block; background-color:<?= $color; ?>; color:<?= $color2; ?>; border:1px solid white; text-align:center; cursor:pointer;" onclick="board('<?= $room->room_number ?>','<?= $room->type; ?>')">
<?= $room->room_number ?><br>
<?= $room->name ?><br>
<del>N</del><?= $room->price ?>
</td>



	<?php
}
?>
</tr>
</table>
</div>



<div id="myModalBoard" class="modal fade" role="dialog" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Enter Guest details</h4>
      </div>
      <div class="modal-body">
        <div class="taken-form">

     <div id="dprice"></div>

    <?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['taken/create']),
    'options'=>[
    'class'=>'aim',
    'name'=>'form7',
    'id' =>'form7'
    ]
    ]); ?>
     

<?= $form->field($model, 'utila')->textInput(['maxlength' => true, 'id'=>'util','onkeyup'=>'fillup()','autofocus' => true,'autocomplete'=>'off1'])->label('Customers Name') ?>

<div id="fida"></div>

     <?= $form->field($model, 'guest_id')->hiddenInput(['id'=>'guest_id'])->label(false) ?>

    <?= $form->field($model, 'address')->textarea(['rows' => 1,'id'=>'addresso']) ?>

    <?= $form->field($model, 'phone')->textInput(['maxlength' => true,'id'=>'phoneo']) ?>

    <?= $form->field($model, 'email')->textInput(['maxlength' => true, 'id'=>'emailo']) ?>

    <?= $form->field($model, 'room_type')->hiddenInput(['id'=>'room_type'])->label(false) ?>

   

    <?= $form->field($model, 'room_no')->textInput(['id'=>'room','readonly'=>'readonly']) ?>  
    <?= Html::hiddenInput('room_name','',['id'=>'room_name','class'=>'form-control','readonly'=>'readonly']) ?> 







    <?= $form->field($model, 'nok')->textInput(['maxlength' => true])->label('Next of kin') ?>
 
<?= $form->field($model, 'rate')->textInput(['placeholder'=>'Enter the rate at which you are giving this room to this guest','id'=>'rrate']) ?>

    <?= $form->field($model, 'deposit')->textInput(['placeholder'=>'Enter the total amount paid by guest for this room here'])->label('Paid') ?>

    <?= $form->field($model, 'discount')->hiddenInput(['placeholder'=>'','value'=>'0'])->label(false) ?>

    <?= $form->field($model,'payment_method')->dropdownList(ArrayHelper::map(Payment::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','name'),['prompt'=>'']) ?>

    
    <?= $form->field($model,'id_type')->dropdownList(ArrayHelper::map(IdType::find()->all(),'type','type'),['prompt'=>'']) ?>
    

    <?= $form->field($model, 'id_no')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model,'complimentary')->dropdownList([1=>'Complimentary',2=>'Reservation'],['prompt'=>'','id'=>'complimentary'])->label('Booking Type') ?>
    <?= $form->field($model, 'shop_id')->hiddenInput(['maxlength' => true,'value'=>Yii::$app->user->identity->shop_id])->label(false) ?>
    <?= $form->field($model, 'reservation_no')->textInput() ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>




<?= $form->field($model,'bill_to')->dropdownList([1=>'Self',2=>'Company',3=>'Do not bill'],['prompt'=>'','onchange'=>'dobill()','id'=>'bill_to']) ?>
    <div class="form-group" id="accounts">
</div>
   
<?= $form->field($model, 'departure')->textInput(['id'=>'room','style'=>'background-color:blue; color:#fff;'])->label('How many nights is guest staying') ?> 





    

  

    <div class="form-group" style="margin-top:40px;">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>