<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker; 
use frontend\models\Charts;
use frontend\models\Vendors;
use frontend\models\Customers;
use frontend\models\Ledger;

?>
<h1>Profit and Loss</h1>


<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['requisitions/pnl'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
    ]
]); ?>

</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>

<div id="holder">
	<table class="table table-bordered table-striped">
		<tr>
<td colspan="2" style="text-transform:uppercase; font-size:26px; font-weight:bold;">Income</td>
		</tr>

	
<?php $to_inc=0; $to_exp=0;
if($income!=null || $expenditure!=null || $income_details3!=null){  
    ?>

<div style="font-weight:bold; font-size:18px;">
Income statement from rep2 <?= date('jS F Y',strtotime($from)) ?> to <?= date('jS F Y',strtotime($to)) ?>
</div>
    <?php
foreach($income_details3 as $inc)   //   15719090463     //  15732074523
{ $to_inc+=$inc['amount'];
	?>
	<tr>
<td onmouseover="showup('<?= $inc['id'] ?>')" onmouseout="showup2('<?= $inc['id'] ?>')"><?php  echo Charts::findOne($inc['chart_account'])->title ?> 
    
    <?php // echo  Charts::findOne(Ledger::find()->where(['transaction_id'=>$inc['tlink']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one()->chart_account2)->title ?>
        
         <a style="display:none;" id="<?= $inc['id']?>" class="narrow" target="_blank" href="<?= Yii::$app->UrlManager->createUrl(['/ledger/trial_d2','id'=>$inc['chart_account'],'from'=>$date1,'to'=>$date2,'tid'=>$inc['transaction_id']]) ?>">Details</a>

    </td>
<td><del>N</del> <?= number_format($inc['amount'],2) ?> - <?= $inc['transaction_id'] ?> - <?= date('jS F Y',strtotime($inc['created_at'])) ?></td>

	</tr>

	<?php
}
}
?>


<tr style="font-weight:bold;">
<td>TOTAL INCOME</td><td style="border-bottom:3px solid #000;"><?= number_format($to_inc,2) ?></td>
</tr>


	<tr>
<td colspan="2" style="text-transform:uppercase; font-size:26px; font-weight:bold;">Expenditure</td>
		</tr>

	
<?php
if($expenditure!=null  || $expense_details!=null){
foreach($expense_details3 as $exp)
{ $to_exp+=$exp['amount'];
	?>
	<tr>
<td onmouseover="showup('<?= $exp['id'] ?>')" onmouseout="showup2('<?= $exp['id'] ?>')" ><?php // echo Charts::findOne($exp['chart_account2'])->title ?>  
    <?= ucwords(Charts::find()->where(['id'=>$exp['chart_account']])->one()->title); ?>
    <?php // echo  Charts::findOne(Ledger::find()->where(['transaction_id'=>$exp['tlink']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one()->chart_account)->title ?>


    <a style="display: none;" class="narrow" id="<?= $exp['id'] ?>"   target="_blank" href="<?= Yii::$app->UrlManager->createUrl(['/ledger/trial_d2','id'=>$exp['chart_account'],'from'=>$date1,'to'=>$date2,'tid'=>$inc['transaction_id']]) ?>">Details</a>
        
    </td>
<td><del>N</del> <?= number_format($exp['amount'],2) ?></td>

	</tr>

	<?php
}}
?>

<tr style="font-weight:bold;">
<td>TOTAL EXPENDITURE 78</td><td style="border-bottom:3px solid #000;"><?= number_format($to_exp,2) ?></td>
</tr>

<tr>
<?php if($to_inc>$to_exp){ ?>
<td style="text-transform:uppercase; font-size:26px; font-weight:bold;">Total net Profit</td>
<td style="text-transform:uppercase; font-size:18px; font-weight:bold;"><del>N</del> <?= number_format($to_inc-$to_exp,2) ?></td>
<?php } ?>

<?php if($to_exp>$to_inc){ ?>
<td style="text-transform:uppercase; font-size:26px; font-weight:bold;">Total Loss</td>
<td style="text-transform:uppercase; font-size:18px; font-weight:bold;"><del>N</del> <?= number_format($to_exp-$to_inc,2) ?></td>
<?php } ?>
</tr>
</table>
</div>

<div>
    <input type="button" value="Print" onclick="print()" class="btn btn-success">
</div>

</div>