<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\models\User;
use yii\helpers\ArrayHelper;


/* @var $this yii\web\View */
/* @var $model frontend\models\Shifts */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="shifts-form">

    <?php $form = ActiveForm::begin(); ?>    

    <?php echo $form->field($model, 'shift_id')->dropDownList(
    [1=>'Morning Shift',2=>'Afternoon Shift',3=>'Night Shift'],['prompt'=>''])->label('Select shift') ?>

    <?= $form->field($model, 'shop_id')->hiddenInput(['value'=>Yii::$app->user->identity->shop_id])->label(false) ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <?= $form->field($model, 'staff_id')->hiddenInput(['value'=>Yii::$app->user->identity->id])->label(false) ?>

    
     <?php echo $form->field($model, 'shift_name')->dropDownList(
    ArrayHelper::map(User::find()->where(['cid'=>Yii::$app->user->identity->cid,'department'=>1,'place'=>2])->all(),'id','username'),['prompt'=>''])->label('Select Staff Name') ?>

    

    <?= $form->field($model, 'created_at')->hiddenInput(['value'=>date('Y-m-d H:i:s')])->label(false) ?>

    <?= $form->field($model, 'stamp')->hiddenInput(['value'=>time()])->label(false) ?>

    <div class="form-group">
        <?= Html::submitButton('Create Shift', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
