/*
 Highstock JS v9.3.2 (2021-11-29)

 Indicator series type for Highcharts Stock

 (c) 2010-2021 Rafal Sebestjanski

 License: www.highcharts.com/license
*/
'use strict';(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/indicators/dmi",["highcharts","highcharts/modules/stock"],function(k){c(k);c.Highcharts=k;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function k(c,f,g,k){c.hasOwnProperty(f)||(c[f]=k.apply(null,g))}c=c?c._modules:{};k(c,"Stock/Indicators/MultipleLinesComposition.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],
function(c,f){var g=c.seriesTypes.sma,k=f.defined,x=f.error,t=f.merge,u;(function(f){function u(b){var a,d=[];b=b||this.points;if(this.fillGraph&&this.nextPoints){if((a=g.prototype.getGraphPath.call(this,this.nextPoints))&&a.length){a[0][0]="L";d=g.prototype.getGraphPath.call(this,b);a=a.slice(0,d.length);for(var e=a.length-1;0<=e;e--)d.push(a[e])}}else d=g.prototype.getGraphPath.apply(this,arguments);return d}function y(){var b=this,d=b.linesApiNames,l=b.areaLinesNames,e=b.points,w=b.options,h=b.graph,
n={options:{gapSize:w.gapSize}},f=[],r=b.getTranslatedLinesNames(b.pointValKey),y=e.length,v;r.forEach(function(b,a){for(f[a]=[];y--;)v=e[y],f[a].push({x:v.x,plotX:v.plotX,plotY:v[b],isNull:!k(v[b])});y=e.length});if(this.userOptions.fillColor&&l.length){var z=r.indexOf(a(l[0]));z=f[z];l=1===l.length?e:f[r.indexOf(a(l[1]))];r=b.color;b.points=l;b.nextPoints=z;b.color=this.userOptions.fillColor;b.options=t(e,n);b.graph=b.area;b.fillGraph=!0;c.seriesTypes.sma.prototype.drawGraph.call(b);b.area=b.graph;
delete b.nextPoints;delete b.fillGraph;b.color=r}d.forEach(function(a,d){f[d]?(b.points=f[d],w[a]?b.options=t(w[a].styles,n):x('Error: "There is no '+a+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),b.graph=b["graph"+a],g.prototype.drawGraph.call(b),b["graph"+a]=b.graph):x('Error: "'+a+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});b.points=e;b.options=w;b.graph=
h;g.prototype.drawGraph.call(b)}function h(b){var d=[];(this.pointArrayMap||[]).forEach(function(m){m!==b&&d.push(a(m))});return d}function a(a){return"plot"+a.charAt(0).toUpperCase()+a.slice(1)}function d(a){var b=[];(this.pointArrayMap||[]).forEach(function(d){b.push(a[d])});return b}function w(){var a=this,d=a.pointArrayMap,c=[],e;c=a.getTranslatedLinesNames();g.prototype.translate.apply(a,arguments);a.points.forEach(function(b){d.forEach(function(d,m){e=b[d];a.dataModify&&(e=a.dataModify.modifyValue(e));
null!==e&&(b[c[m]]=a.yAxis.toPixels(e,!0))})})}var r=[],v=["bottomLine"],z=["top","bottom"],C=["top"];f.compose=function(a){if(-1===r.indexOf(a)){r.push(a);var b=a.prototype;b.linesApiNames=b.linesApiNames||v.slice();b.pointArrayMap=b.pointArrayMap||z.slice();b.pointValKey=b.pointValKey||"top";b.areaLinesNames=b.areaLinesNames||C.slice();b.drawGraph=y;b.getGraphPath=u;b.toYData=d;b.translate=w;b.getTranslatedLinesNames=h}return a}})(u||(u={}));return u});k(c,"Stock/Indicators/DMI/DMIIndicator.js",
[c["Stock/Indicators/MultipleLinesComposition.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f,g){var k=this&&this.__extends||function(){var c=function(h,a){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var d in c)c.hasOwnProperty(d)&&(a[d]=c[d])};return c(h,a)};return function(h,a){function d(){this.constructor=h}c(h,a);h.prototype=null===a?Object.create(a):(d.prototype=a.prototype,new d)}}(),x=f.seriesTypes.sma,
t=g.correctFloat,u=g.extend,A=g.isArray,B=g.merge;g=function(c){function h(){var a=null!==c&&c.apply(this,arguments)||this;a.options=void 0;return a}k(h,c);h.prototype.calculateDM=function(a,d,c){var h=a[d][1],f=a[d][2],g=a[d-1][1];a=a[d-1][2];return t(h-g>a-f?c?Math.max(h-g,0):0:c?0:Math.max(a-f,0))};h.prototype.calculateDI=function(a,d){return a/d*100};h.prototype.calculateDX=function(a,d){return t(Math.abs(a-d)/Math.abs(a+d)*100)};h.prototype.smoothValues=function(a,d,c){return t(a-a/c+d)};h.prototype.getTR=
function(a,d){return t(Math.max(a[1]-a[2],d?Math.abs(a[1]-d[3]):0,d?Math.abs(a[2]-d[3]):0))};h.prototype.getValues=function(a,d){d=d.period;var c=a.xData,h=(a=a.yData)?a.length:0,f=[],g=[],k=[];if(!(c.length<=d)&&A(a[0])&&4===a[0].length){var b=0,m=0,l=0,e;for(e=1;e<h;e++)if(e<=d){var p=this.calculateDM(a,e,!0);var q=this.calculateDM(a,e);var n=this.getTR(a[e],a[e-1]);b+=p;m+=q;l+=n;e===d&&(n=this.calculateDI(b,l),q=this.calculateDI(m,l),p=this.calculateDX(b,m),f.push([c[e],p,n,q]),g.push(c[e]),k.push([p,
n,q]))}else p=this.calculateDM(a,e,!0),q=this.calculateDM(a,e),n=this.getTR(a[e],a[e-1]),b=this.smoothValues(b,p,d),m=this.smoothValues(m,q,d),l=this.smoothValues(l,n,d),n=this.calculateDI(b,l),q=this.calculateDI(m,l),p=this.calculateDX(b,m),f.push([c[e],p,n,q]),g.push(c[e]),k.push([p,n,q]);return{values:f,xData:g,yData:k}}};h.defaultOptions=B(x.defaultOptions,{params:{index:void 0},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">DX</span>: {point.y}<br/><span style="color: {point.series.options.plusDILine.styles.lineColor}">+DI</span>: {point.plusDI}<br/><span style="color: {point.series.options.minusDILine.styles.lineColor}">-DI</span>: {point.minusDI}<br/>'},
plusDILine:{styles:{lineWidth:1,lineColor:"#06b535"}},minusDILine:{styles:{lineWidth:1,lineColor:"#f21313"}},dataGrouping:{approximation:"averages"}});return h}(x);u(g.prototype,{areaLinesNames:[],nameBase:"DMI",linesApiNames:["plusDILine","minusDILine"],pointArrayMap:["y","plusDI","minusDI"],parallelArrays:["x","y","plusDI","minusDI"],pointValKey:"y"});c.compose(g);f.registerSeriesType("dmi",g);"";return g});k(c,"masters/indicators/dmi.src.js",[],function(){})});
//# sourceMappingURL=dmi.js.map